from typing import Any, Iterable, Iterator, List, Optional, Union

from . import AppriseAsset, NotifyBase
from .config import ConfigBase

_Configs = Union[ConfigBase, str, Iterable[str]]

class AppriseConfig:
    def __init__(
        self,
        paths: Optional[_Configs] = ...,
        asset: Optional[AppriseAsset] = ...,
        cache: bool = ...,
        recursion: int = ...,
        insecure_includes: bool = ...,
        **kwargs: Any
    ) -> None: ...
    def add(
        self,
        configs: _Configs,
        asset: Optional[AppriseAsset] = ...,
        cache: bool = ...,
        recursion: Optional[bool] = ...,
        insecure_includes: Optional[bool] = ...
    ) -> bool: ...
    def add_config(
        self,
        content: str,
        asset: Optional[AppriseAsset] = ...,
        tag: Optional[str] = ...,
        format: Optional[str] = ...,
        recursion: Optional[int] = ...,
        insecure_includes: Optional[bool] = ...
    ) -> bool: ...
    def servers(self, tag: str = ..., *args: Any, **kwargs: Any) -> List[ConfigBase]: ...
    def instantiate(
        url: str,
        asset: Optional[AppriseAsset] = ...,
        tag: Optional[str] = ...,
        cache: Optional[bool] = ...
    ) -> NotifyBase: ...
    def clear(self) -> None: ...
    def server_pop(self, index: int) -> ConfigBase: ...
    def pop(self, index: int = ...) -> ConfigBase: ...
    def __getitem__(self, index: int) -> ConfigBase: ...
    def __bool__(self) -> bool: ...
    def __nonzero__(self) -> bool: ...
    def __iter__(self) -> Iterator[ConfigBase]: ...
    def __len__(self) -> int: ...