
# This file was autogenerated from pk-enum.h by pk-enum-converter.py
# on Fri Jan 21 16:01:47 2022 UTC
#
# License for original source:
#
# Copyright (C) 2007-2014 Richard Hughes <richard@hughsie.com>
#
# Licensed under the GNU Lesser General Public License Version 2.1
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301 USA
#

from __future__ import annotations
import sys
from enum import Flag, auto

class PkFlag(Flag):
    @classmethod
    def from_pkstring(cls, pkstring: str):
        for name, member in cls.__members__.items():
            if member.pkstring == pkstring:
                return cls(member.value)
        # Return "unknown" flag
        return cls(1)

    @classmethod
    def from_index(cls, index: int):
        return cls(1 << index)

    @property
    def pkstring(self) -> str:
        if self.name is None:
            return " | ".join([f.pkstring for f in self])
        return self.name.lower().replace("_", "-")

    @property
    def desc(self) -> str:
        if self.name is None:
            return ", ".join([f.desc for f in self])
        description = self.name.lower().replace("_", " ")
        return description.capitalize()

    @property
    def index(self) -> int:
        return self.value.bit_length() - 1

    if sys.version_info < (3, 11):
        def __iter__(self):
            for i in range(self._value_.bit_length()):
                val = 1 << i
                if val & self._value_ == val:
                    yield self.__class__(val)


class Role(PkFlag):
    """
    What we were asked to do, this never changes for the lifetime of the
    transaction.
    Icons that have to represent the whole "aim" of the transaction will use
    these constants

    * Role.UNKNOWN:  Unknow request
    * Role.CANCEL:  Cancel transaction
    * Role.DEPENDS_ON:  Get package dependencies
    * Role.GET_DETAILS:  Get package details
    * Role.GET_FILES:
    * Role.GET_PACKAGES:  Get available packages
    * Role.GET_REPO_LIST:  Get repository list
    * Role.REQUIRED_BY:  Get packages required by given package
    * Role.GET_UPDATE_DETAIL:  Get update details
    * Role.GET_UPDATES:  Get available updates
    * Role.INSTALL_FILES:  Install package files
    * Role.INSTALL_PACKAGES:  Install packages
    * Role.INSTALL_SIGNATURE:  Install signature
    * Role.REFRESH_CACHE:  Refresh cache
    * Role.REMOVE_PACKAGES:  Remove packages
    * Role.REPO_ENABLE:  Enable repository
    * Role.REPO_SET_DATA:
    * Role.RESOLVE:  Resolve depdencies
    * Role.SEARCH_DETAILS:  Search for details
    * Role.SEARCH_FILE:  Search for file
    * Role.SEARCH_GROUP:  Search for group
    * Role.SEARCH_NAME:  Search for package name
    * Role.UPDATE_PACKAGES:  Update packages
    * Role.WHAT_PROVIDES:  Get what a package provides
    * Role.ACCEPT_EULA:  Accept an EULA
    * Role.DOWNLOAD_PACKAGES:  Download packages
    * Role.GET_DISTRO_UPGRADES:  Get available distribution upgrades
    * Role.GET_CATEGORIES:  Get available categories
    * Role.GET_OLD_TRANSACTIONS:  Get old transation information
    * Role.REPAIR_SYSTEM:  Repair system
    * Role.GET_DETAILS_LOCAL:  Get details on local package
    * Role.GET_FILES_LOCAL:  Get files provided by local package
    * Role.REPO_REMOVE:  Remove repository
    * Role.UPGRADE_SYSTEM:  Upgrade system
    """
    UNKNOWN = auto()
    CANCEL = auto()
    DEPENDS_ON = auto()
    GET_DETAILS = auto()
    GET_FILES = auto()
    GET_PACKAGES = auto()
    GET_REPO_LIST = auto()
    REQUIRED_BY = auto()
    GET_UPDATE_DETAIL = auto()
    GET_UPDATES = auto()
    INSTALL_FILES = auto()
    INSTALL_PACKAGES = auto()
    INSTALL_SIGNATURE = auto()
    REFRESH_CACHE = auto()
    REMOVE_PACKAGES = auto()
    REPO_ENABLE = auto()
    REPO_SET_DATA = auto()
    RESOLVE = auto()
    SEARCH_DETAILS = auto()
    SEARCH_FILE = auto()
    SEARCH_GROUP = auto()
    SEARCH_NAME = auto()
    UPDATE_PACKAGES = auto()
    WHAT_PROVIDES = auto()
    ACCEPT_EULA = auto()
    DOWNLOAD_PACKAGES = auto()
    GET_DISTRO_UPGRADES = auto()
    GET_CATEGORIES = auto()
    GET_OLD_TRANSACTIONS = auto()
    REPAIR_SYSTEM = auto()
    GET_DETAILS_LOCAL = auto()
    GET_FILES_LOCAL = auto()
    REPO_REMOVE = auto()
    UPGRADE_SYSTEM = auto()

class Status(PkFlag):
    """
    What status we are now; this can change for each transaction giving a
    status of what sort of thing is happening
    Icons that change to represent the current status of the transaction will
    use these constants
    If you add to these, make sure you add filenames in gpk-watch.c also

    A typical transaction will do:
    - schedule task
        WAIT
    - run task
        SETUP
    - wait for lock
        RUNNING

    This means that backends should run pk_backend_set_status (backend,
    PK_STATUS_ENUM_RUNNING)
    when they are ready to start running the transaction and after a lock has
    been got.

    * Status.UNKNOWN:  Unknown status
    * Status.WAIT:  Waiting
    * Status.SETUP:  Setting up
    * Status.RUNNING:  Running
    * Status.QUERY:
    * Status.INFO:
    * Status.REMOVE:  Removing
    * Status.REFRESH_CACHE:  Refreshing cache
    * Status.DOWNLOAD:  Downloading
    * Status.INSTALL:  Installing
    * Status.UPDATE:  Updating
    * Status.CLEANUP:  Cleaning up
    * Status.OBSOLETE:
    * Status.DEP_RESOLVE:  Resolving dependencies
    * Status.SIG_CHECK:  Checking signatures
    * Status.TEST_COMMIT:  Testing commit
    * Status.COMMIT:  Committing
    * Status.REQUEST:
    * Status.FINISHED:  Finished
    * Status.CANCEL:  Cancelling
    * Status.DOWNLOAD_REPOSITORY:  Downloading respository
    * Status.DOWNLOAD_PACKAGELIST:  Donwloading package list
    * Status.DOWNLOAD_FILELIST:  Downloading file list
    * Status.DOWNLOAD_CHANGELOG:  Downloading changelog information
    * Status.DOWNLOAD_GROUP:  Downloading group information
    * Status.DOWNLOAD_UPDATEINFO:  Downloading update information
    * Status.REPACKAGING:  Repackaging
    * Status.LOADING_CACHE:  Loading cache
    * Status.SCAN_APPLICATIONS:  Scanning for applications
    * Status.GENERATE_PACKAGE_LIST:  Generating package list
    * Status.WAITING_FOR_LOCK:  Waiting for lock
    * Status.WAITING_FOR_AUTH:  Waiting for authentication/authorization
    * Status.SCAN_PROCESS_LIST:  Scanning running processes
    * Status.CHECK_EXECUTABLE_FILES:  Checking executable files
    * Status.CHECK_LIBRARIES:  Checking libraries
    * Status.COPY_FILES:  Copying files
    * Status.RUN_HOOK:  Running package hook
    """
    UNKNOWN = auto()
    WAIT = auto()
    SETUP = auto()
    RUNNING = auto()
    QUERY = auto()
    INFO = auto()
    REMOVE = auto()
    REFRESH_CACHE = auto()
    DOWNLOAD = auto()
    INSTALL = auto()
    UPDATE = auto()
    CLEANUP = auto()
    OBSOLETE = auto()
    DEP_RESOLVE = auto()
    SIG_CHECK = auto()
    TEST_COMMIT = auto()
    COMMIT = auto()
    REQUEST = auto()
    FINISHED = auto()
    CANCEL = auto()
    DOWNLOAD_REPOSITORY = auto()
    DOWNLOAD_PACKAGELIST = auto()
    DOWNLOAD_FILELIST = auto()
    DOWNLOAD_CHANGELOG = auto()
    DOWNLOAD_GROUP = auto()
    DOWNLOAD_UPDATEINFO = auto()
    REPACKAGING = auto()
    LOADING_CACHE = auto()
    SCAN_APPLICATIONS = auto()
    GENERATE_PACKAGE_LIST = auto()
    WAITING_FOR_LOCK = auto()
    WAITING_FOR_AUTH = auto()
    SCAN_PROCESS_LIST = auto()
    CHECK_EXECUTABLE_FILES = auto()
    CHECK_LIBRARIES = auto()
    COPY_FILES = auto()
    RUN_HOOK = auto()

class Exit(PkFlag):
    """
    How the backend exited

    * Exit.UNKNOWN:  Unknown exit status
    * Exit.SUCCESS:  Backend exited successfully
    * Exit.FAILED:  Backend failed
    * Exit.CANCELLED:  Backend was cancelled
    * Exit.KEY_REQUIRED:  A repository encryption key needs installing
    * Exit.EULA_REQUIRED:  A EULA is required to be accepted
    * Exit.KILLED:  Backend was killed
    * Exit.MEDIA_CHANGE_REQUIRED:  Media change required
    * Exit.NEED_UNTRUSTED:
    * Exit.CANCELLED_PRIORITY:  Cancelled due to higher priority task
    * Exit.SKIP_TRANSACTION:
    * Exit.REPAIR_REQUIRED:  Package database requires repairing
    """
    UNKNOWN = auto()
    SUCCESS = auto()
    FAILED = auto()
    CANCELLED = auto()
    KEY_REQUIRED = auto()
    EULA_REQUIRED = auto()
    KILLED = auto()
    MEDIA_CHANGE_REQUIRED = auto()
    NEED_UNTRUSTED = auto()
    CANCELLED_PRIORITY = auto()
    SKIP_TRANSACTION = auto()
    REPAIR_REQUIRED = auto()

class Network(PkFlag):
    """
    Network type

    * Network.UNKNOWN:  Unknown network
    * Network.OFFLINE:  Offline (no network)
    * Network.ONLINE:  Online (network type unknown)
    * Network.WIRED:  Wired network
    * Network.WIFI:  WiFi network
    * Network.MOBILE:  Mobile network
    """
    UNKNOWN = auto()
    OFFLINE = auto()
    ONLINE = auto()
    WIRED = auto()
    WIFI = auto()
    MOBILE = auto()

class Filter(PkFlag):
    """
    The filter types

    * Filter.UNKNOWN:  Unknown filter
    * Filter.NONE:  No filter
    * Filter.INSTALLED:  Filter for installed packages
    * Filter.NOT_INSTALLED:  Filter for not installed packages
    * Filter.DEVELOPMENT:  Filter for development packages
    * Filter.NOT_DEVELOPMENT:  Filter for non-development packages
    * Filter.GUI:  Filter for GUI packages
    * Filter.NOT_GUI:  Filter for non-GUI packages
    * Filter.FREE:  Filter for free packages
    * Filter.NOT_FREE:  Filter for non-free packages
    * Filter.VISIBLE:  Filter for visible packages
    * Filter.NOT_VISIBLE:  Filter for invisible packages
    * Filter.SUPPORTED:  Filter for supported packages
    * Filter.NOT_SUPPORTED:  Filter for not supported packages
    * Filter.BASENAME:  Filter for packages that match basename
    * Filter.NOT_BASENAME:  Filter for packages that don't match basename
    * Filter.NEWEST:  Filter for newest packages
    * Filter.NOT_NEWEST:  Filter for not newest packages
    * Filter.ARCH:  Filter for packages that match architecture
    * Filter.NOT_ARCH:  Filter for packages that don't match architecture
    * Filter.SOURCE:  Filter for source packages
    * Filter.NOT_SOURCE:  Filter for non-source packages
    * Filter.COLLECTIONS:  Filter for collections
    * Filter.NOT_COLLECTIONS:  Filter for not collections
    * Filter.APPLICATION:  Filter for application packages
    * Filter.NOT_APPLICATION:  Filter for non-application packages
    * Filter.DOWNLOADED:  Filter for downloaded packages
    * Filter.NOT_DOWNLOADED:  Filter for not downloaded packages
    """
    @property
    def pkstring(self) -> str:
        pks = self.name
        if pks is None:
            return " | ".join([f.pkstring for f in self])
        if pks in ["DEVELOPMENT", "NOT_DEVELOPMENT"]:
            pks = pks[:-6]
        if pks[:4] == "NOT_":
            pks = "~" + pks[4:]
        return pks.lower().replace("_", "-")

    UNKNOWN = auto()
    NONE = auto()
    INSTALLED = auto()
    NOT_INSTALLED = auto()
    DEVELOPMENT = auto()
    NOT_DEVELOPMENT = auto()
    GUI = auto()
    NOT_GUI = auto()
    FREE = auto()
    NOT_FREE = auto()
    VISIBLE = auto()
    NOT_VISIBLE = auto()
    SUPPORTED = auto()
    NOT_SUPPORTED = auto()
    BASENAME = auto()
    NOT_BASENAME = auto()
    NEWEST = auto()
    NOT_NEWEST = auto()
    ARCH = auto()
    NOT_ARCH = auto()
    SOURCE = auto()
    NOT_SOURCE = auto()
    COLLECTIONS = auto()
    NOT_COLLECTIONS = auto()
    APPLICATION = auto()
    NOT_APPLICATION = auto()
    DOWNLOADED = auto()
    NOT_DOWNLOADED = auto()

class Restart(PkFlag):
    """
    What restart we need to after a transaction, ordered by severity

    * Restart.UNKNOWN:  Unknown restart state
    * Restart.NONE:  No restart required
    * Restart.APPLICATION:  Need to restart the application
    * Restart.SESSION:  Need to restart the session
    * Restart.SYSTEM:  Need to restart the system
    * Restart.SECURITY_SESSION:
    * Restart.SECURITY_SYSTEM:
    """
    UNKNOWN = auto()
    NONE = auto()
    APPLICATION = auto()
    SESSION = auto()
    SYSTEM = auto()
    SECURITY_SESSION = auto()
    SECURITY_SYSTEM = auto()

class Error(PkFlag):
    """
    The error type

    * Error.UNKNOWN:
    * Error.OOM:  Out of memory
    * Error.NO_NETWORK:  No network access available
    * Error.NOT_SUPPORTED:  Request not supported
    * Error.INTERNAL_ERROR:  Undefined internal error
    * Error.GPG_FAILURE:  GPG encryption failure
    * Error.PACKAGE_ID_INVALID:  Invalid package ID provided
    * Error.PACKAGE_NOT_INSTALLED:  Requested package not installed
    * Error.PACKAGE_NOT_FOUND:  Requested package not found
    * Error.PACKAGE_ALREADY_INSTALLED:  Requested package already installed
    * Error.PACKAGE_DOWNLOAD_FAILED:  Failed to download package
    * Error.GROUP_NOT_FOUND:  Requested group not gound
    * Error.GROUP_LIST_INVALID:  Invalid group list provided
    * Error.DEP_RESOLUTION_FAILED:  Failed to resolve dependencies
    * Error.FILTER_INVALID:  Invalid filter provides
    * Error.CREATE_THREAD_FAILED:  Failed to create thread
    * Error.TRANSACTION_ERROR:  Error occurred during transaction
    * Error.TRANSACTION_CANCELLED:  Transaction was cancelled
    * Error.NO_CACHE:  No cache available
    * Error.REPO_NOT_FOUND:  Requested repository not found
    * Error.CANNOT_REMOVE_SYSTEM_PACKAGE:  Not allowed to remove system package
    * Error.PROCESS_KILL:  Process killed
    * Error.FAILED_INITIALIZATION:
    * Error.FAILED_FINALISE:
    * Error.FAILED_CONFIG_PARSING:  Configuration is not valid
    * Error.CANNOT_CANCEL:
    * Error.CANNOT_GET_LOCK:  Cannot get lock
    * Error.NO_PACKAGES_TO_UPDATE:  No packages to update
    * Error.CANNOT_WRITE_REPO_CONFIG:  Cannot write repository configuration
    * Error.LOCAL_INSTALL_FAILED:
    * Error.BAD_GPG_SIGNATURE:  Bad GPG signature found
    * Error.MISSING_GPG_SIGNATURE:  Required GPG signature not found
    * Error.CANNOT_INSTALL_SOURCE_PACKAGE:  Cannot install source package
    * Error.REPO_CONFIGURATION_ERROR:
    * Error.NO_LICENSE_AGREEMENT:
    * Error.FILE_CONFLICTS:  File conflicts detected
    * Error.PACKAGE_CONFLICTS:  Package conflict
    * Error.REPO_NOT_AVAILABLE:  Repository not available
    * Error.INVALID_PACKAGE_FILE:
    * Error.PACKAGE_INSTALL_BLOCKED:  Package installation blocked
    * Error.PACKAGE_CORRUPT:  Package corruption occurred
    * Error.ALL_PACKAGES_ALREADY_INSTALLED:  All packages already installed
    * Error.FILE_NOT_FOUND:  Required file not found
    * Error.NO_MORE_MIRRORS_TO_TRY:  Out of repository mirrors to try
    * Error.NO_DISTRO_UPGRADE_DATA:  No distribution upgrade path found
    * Error.INCOMPATIBLE_ARCHITECTURE:  Incompatible architecture found
    * Error.NO_SPACE_ON_DEVICE:  Out of required disk space
    * Error.MEDIA_CHANGE_REQUIRED:  Need to change media
    * Error.NOT_AUTHORIZED:  Authorization failed
    * Error.UPDATE_NOT_FOUND:  Update not found
    * Error.CANNOT_INSTALL_REPO_UNSIGNED:
         Installation repository missing signature
    * Error.CANNOT_UPDATE_REPO_UNSIGNED:  Update repository missing signature
    * Error.CANNOT_GET_FILELIST:  Cannot get file list
    * Error.CANNOT_GET_REQUIRES:  Cannot get package requirements
    * Error.CANNOT_DISABLE_REPOSITORY:  Cannot disable reposoitory
    * Error.RESTRICTED_DOWNLOAD:
    * Error.PACKAGE_FAILED_TO_CONFIGURE:  Package failed to configure
    * Error.PACKAGE_FAILED_TO_BUILD:  Package failed to build
    * Error.PACKAGE_FAILED_TO_INSTALL:  Package failed to install
    * Error.PACKAGE_FAILED_TO_REMOVE:  Package failed to remove
    * Error.UPDATE_FAILED_DUE_TO_RUNNING_PROCESS:
    * Error.PACKAGE_DATABASE_CHANGED:
    * Error.PROVIDE_TYPE_NOT_SUPPORTED:
    * Error.INSTALL_ROOT_INVALID:  Installtion root not suitable
    * Error.CANNOT_FETCH_SOURCES:  Cannot fetch sources
    * Error.CANCELLED_PRIORITY:  Cancelled due to higher priority task
    * Error.UNFINISHED_TRANSACTION:  Transaction unfinished
    * Error.LOCK_REQUIRED:  Required lock not available
    * Error.REPO_ALREADY_SET:
    """
    @property
    def pkstring(self) -> str:
        if self == Error.UPDATE_FAILED_DUE_TO_RUNNING_PROCESS:
            return "failed-due-to-running-process"
        return super().pkstring

    UNKNOWN = auto()
    OUT_OF_MEMORY = auto()
    NO_NETWORK = auto()
    NOT_SUPPORTED = auto()
    INTERNAL_ERROR = auto()
    GPG_FAILURE = auto()
    PACKAGE_ID_INVALID = auto()
    PACKAGE_NOT_INSTALLED = auto()
    PACKAGE_NOT_FOUND = auto()
    PACKAGE_ALREADY_INSTALLED = auto()
    PACKAGE_DOWNLOAD_FAILED = auto()
    GROUP_NOT_FOUND = auto()
    GROUP_LIST_INVALID = auto()
    DEP_RESOLUTION_FAILED = auto()
    FILTER_INVALID = auto()
    CREATE_THREAD_FAILED = auto()
    TRANSACTION_ERROR = auto()
    TRANSACTION_CANCELLED = auto()
    NO_CACHE = auto()
    REPO_NOT_FOUND = auto()
    CANNOT_REMOVE_SYSTEM_PACKAGE = auto()
    PROCESS_KILL = auto()
    FAILED_INITIALIZATION = auto()
    FAILED_FINALISE = auto()
    FAILED_CONFIG_PARSING = auto()
    CANNOT_CANCEL = auto()
    CANNOT_GET_LOCK = auto()
    NO_PACKAGES_TO_UPDATE = auto()
    CANNOT_WRITE_REPO_CONFIG = auto()
    LOCAL_INSTALL_FAILED = auto()
    BAD_GPG_SIGNATURE = auto()
    MISSING_GPG_SIGNATURE = auto()
    CANNOT_INSTALL_SOURCE_PACKAGE = auto()
    REPO_CONFIGURATION_ERROR = auto()
    NO_LICENSE_AGREEMENT = auto()
    FILE_CONFLICTS = auto()
    PACKAGE_CONFLICTS = auto()
    REPO_NOT_AVAILABLE = auto()
    INVALID_PACKAGE_FILE = auto()
    PACKAGE_INSTALL_BLOCKED = auto()
    PACKAGE_CORRUPT = auto()
    ALL_PACKAGES_ALREADY_INSTALLED = auto()
    FILE_NOT_FOUND = auto()
    NO_MORE_MIRRORS_TO_TRY = auto()
    NO_DISTRO_UPGRADE_DATA = auto()
    INCOMPATIBLE_ARCHITECTURE = auto()
    NO_SPACE_ON_DEVICE = auto()
    MEDIA_CHANGE_REQUIRED = auto()
    NOT_AUTHORIZED = auto()
    UPDATE_NOT_FOUND = auto()
    CANNOT_INSTALL_REPO_UNSIGNED = auto()
    CANNOT_UPDATE_REPO_UNSIGNED = auto()
    CANNOT_GET_FILELIST = auto()
    CANNOT_GET_REQUIRES = auto()
    CANNOT_DISABLE_REPOSITORY = auto()
    RESTRICTED_DOWNLOAD = auto()
    PACKAGE_FAILED_TO_CONFIGURE = auto()
    PACKAGE_FAILED_TO_BUILD = auto()
    PACKAGE_FAILED_TO_INSTALL = auto()
    PACKAGE_FAILED_TO_REMOVE = auto()
    UPDATE_FAILED_DUE_TO_RUNNING_PROCESS = auto()
    PACKAGE_DATABASE_CHANGED = auto()
    PROVIDE_TYPE_NOT_SUPPORTED = auto()
    INSTALL_ROOT_INVALID = auto()
    CANNOT_FETCH_SOURCES = auto()
    CANCELLED_PRIORITY = auto()
    UNFINISHED_TRANSACTION = auto()
    LOCK_REQUIRED = auto()
    REPO_ALREADY_SET = auto()
    OOM = OUT_OF_MEMORY

class Group(PkFlag):
    """
    The group type

    * Group.UNKNOWN:  Unknown group
    * Group.ACCESSIBILITY:  Accessibility related packages
    * Group.ACCESSORIES:  Accessory packages
    * Group.ADMIN_TOOLS:  Administration tools packages
    * Group.COMMUNICATION:  Communication packages
    * Group.DESKTOP_GNOME:  GNOME packages
    * Group.DESKTOP_KDE:  KDE packages
    * Group.DESKTOP_OTHER:  Other desktop packages
    * Group.DESKTOP_XFCE:  XFCE packages
    * Group.EDUCATION:  Education packages
    * Group.FONTS:  Fonts
    * Group.GAMES:  Games
    * Group.GRAPHICS:  Graphics related packages
    * Group.INTERNET:  Internet related packages
    * Group.LEGACY:  Legacy packages
    * Group.LOCALIZATION:  Localization related packages
    * Group.MAPS:  Map related packages
    * Group.MULTIMEDIA:  Multimedia packages
    * Group.NETWORK:  Network related packages
    * Group.OFFICE:  Office packages
    * Group.OTHER:
    * Group.POWER_MANAGEMENT:  Power-management related packages
    * Group.PROGRAMMING:  Programming packages
    * Group.PUBLISHING:  Publishing related packages
    * Group.REPOS:
    * Group.SECURITY:  Security packages
    * Group.SERVERS:  Server related packages
    * Group.SYSTEM:  System packages
    * Group.VIRTUALIZATION:  Virtualization packages
    * Group.SCIENCE:  Science related packages
    * Group.DOCUMENTATION:  Documentation
    * Group.ELECTRONICS:  Electronics package
    * Group.COLLECTIONS:
    * Group.VENDOR:  Vendor defined group
    * Group.NEWEST:  Special group for recently updated packages
    """
    UNKNOWN = auto()
    ACCESSIBILITY = auto()
    ACCESSORIES = auto()
    ADMIN_TOOLS = auto()
    COMMUNICATION = auto()
    DESKTOP_GNOME = auto()
    DESKTOP_KDE = auto()
    DESKTOP_OTHER = auto()
    DESKTOP_XFCE = auto()
    EDUCATION = auto()
    FONTS = auto()
    GAMES = auto()
    GRAPHICS = auto()
    INTERNET = auto()
    LEGACY = auto()
    LOCALIZATION = auto()
    MAPS = auto()
    MULTIMEDIA = auto()
    NETWORK = auto()
    OFFICE = auto()
    OTHER = auto()
    POWER_MANAGEMENT = auto()
    PROGRAMMING = auto()
    PUBLISHING = auto()
    REPOS = auto()
    SECURITY = auto()
    SERVERS = auto()
    SYSTEM = auto()
    VIRTUALIZATION = auto()
    SCIENCE = auto()
    DOCUMENTATION = auto()
    ELECTRONICS = auto()
    COLLECTIONS = auto()
    VENDOR = auto()
    NEWEST = auto()

class UpdateState(PkFlag):
    """
    What state the update is in

    * UpdateState.UNKNOWN:  Update stability unknown
    * UpdateState.STABLE:  Update is a stable release
    * UpdateState.UNSTABLE:  Update is an unstable release
    * UpdateState.TESTING:  Update is a testing release
    """
    UNKNOWN = auto()
    STABLE = auto()
    UNSTABLE = auto()
    TESTING = auto()

class Info(PkFlag):
    """
    The enumerated types used in Package() - these have to refer to a specific
    package action, rather than a general state

    * Info.UNKNOWN:  Package status is unknown
    * Info.INSTALLED:  Package is installed
    * Info.AVAILABLE:  Package is available to be installed
    * Info.LOW:
    * Info.ENHANCEMENT:
    * Info.NORMAL:
    * Info.BUGFIX:
    * Info.IMPORTANT:
    * Info.SECURITY:
    * Info.BLOCKED:  Package is blocked
    * Info.DOWNLOADING:  Package is downloading
    * Info.UPDATING:  Package is updating
    * Info.INSTALLING:  Package is being installed
    * Info.REMOVING:  Package is being removed
    * Info.CLEANUP:  Package is running cleanup
    * Info.OBSOLETING:
    * Info.COLLECTION_INSTALLED:
    * Info.COLLECTION_AVAILABLE:
    * Info.FINISHED:
    * Info.REINSTALLING:  Package is being reinstalled
    * Info.DOWNGRADING:  Package is being downgraded
    * Info.PREPARING:  Package is preparing for installation/removal
    * Info.DECOMPRESSING:  Package is decompressing
    * Info.UNTRUSTED:
    * Info.TRUSTED:
    * Info.UNAVAILABLE:  Package is unavailable
    * Info.CRITICAL:  Update severity is critical; Since: 1.2.4
    """
    UNKNOWN = auto()
    INSTALLED = auto()
    AVAILABLE = auto()
    LOW = auto()
    ENHANCEMENT = auto()
    NORMAL = auto()
    BUGFIX = auto()
    IMPORTANT = auto()
    SECURITY = auto()
    BLOCKED = auto()
    DOWNLOADING = auto()
    UPDATING = auto()
    INSTALLING = auto()
    REMOVING = auto()
    CLEANUP = auto()
    OBSOLETING = auto()
    COLLECTION_INSTALLED = auto()
    COLLECTION_AVAILABLE = auto()
    FINISHED = auto()
    REINSTALLING = auto()
    DOWNGRADING = auto()
    PREPARING = auto()
    DECOMPRESSING = auto()
    UNTRUSTED = auto()
    TRUSTED = auto()
    UNAVAILABLE = auto()
    CRITICAL = auto()

class DistroUpgrade(PkFlag):
    """
    The distro upgrade status

    * DistroUpgrade.UNKNOWN:  Unknown disto upgrade state
    * DistroUpgrade.STABLE:  Upgraded to stable release
    * DistroUpgrade.UNSTABLE:  Upgraded to unstable release
    """
    UNKNOWN = auto()
    STABLE = auto()
    UNSTABLE = auto()

class SigType(PkFlag):
    """
    The signature type type

    * SigType.UNKNOWN:  Unkwown signature type
    * SigType.GPG:  GPG signature
    """
    UNKNOWN = auto()
    GPG = auto()

class MediaType(PkFlag):
    """
    The media type

    * MediaType.UNKNOWN:  Unknown media type
    * MediaType.CD:  Media is a CD
    * MediaType.DVD:  Media is a DVD
    * MediaType.DISC:  Media is a disc (not CD or DVD)
    """
    UNKNOWN = auto()
    CD = auto()
    DVD = auto()
    DISC = auto()

class Authorize(PkFlag):
    """
    The authorization result

    * Authorize.UNKNOWN:  Unknown authorization status
    * Authorize.YES:  Authorized
    * Authorize.NO:  Not authorized
    * Authorize.INTERACTIVE:  Interaction required for authorization
    """
    UNKNOWN = auto()
    YES = auto()
    NO = auto()
    INTERACTIVE = auto()

class UpgradeKind(PkFlag):
    """
    The type of distribution upgrade to perform

    * UpgradeKind.UNKNOWN:
    * UpgradeKind.MINIMAL:  Perform minimal upgrade
    * UpgradeKind.DEFAULT:  Perform default upgrade
    * UpgradeKind.COMPLETE:  Perform complete upgrade
    """
    UNKNOWN = auto()
    MINIMAL = auto()
    DEFAULT = auto()
    COMPLETE = auto()

class TransactionFlag(PkFlag):
    """
    The transaction flags that alter how the transaction is handled

    * TransactionFlag.NONE:  No transaction flag
    * TransactionFlag.ONLY_TRUSTED:  Only allow trusted packages
    * TransactionFlag.SIMULATE:  Simulate transaction
    * TransactionFlag.ONLY_DOWNLOAD:  Only download packages
    * TransactionFlag.ALLOW_REINSTALL:  Allow package reinstallation
    * TransactionFlag.JUST_REINSTALL:  Only allow package reinstallation
    * TransactionFlag.ALLOW_DOWNGRADE:  Allow packages to be downgraded
    """
    NONE = auto()
    ONLY_TRUSTED = auto()
    SIMULATE = auto()
    ONLY_DOWNLOAD = auto()
    ALLOW_REINSTALL = auto()
    JUST_REINSTALL = auto()
    ALLOW_DOWNGRADE = auto()
